package infixModel;

/**
 * State at the start up or after the calculator has been cleared.
 * No digits or operations input yet.
 */
class StartState extends ACalcState {
    /**
     * Singleton instance
     */
    public static final StartState Singleton = new StartState();
    /**
     * Hidden constructor
     */
    private StartState() {
    }
    /**
     * Appends c to the string of digit collected so far 
     * if c is not "0" which is ignored.
     * Go to accumulating state.
     * @param calc The calculator model (context)
     * @param c The digit being entered
     */
    public void enterDigit(InfixCalc calc, char c) {
        //        System.out.println("Start State: enter character " + c);
        calc.setDisplay("" + c);
        if ('0' != c) {
//            calc.setDisplay("" + c);
            calc.setCurState(AccumState.Singleton);
        }
    }
    
    /**
     * Performs the pending operation, and set op as the next pending operation
     * on whatever is computed so far to the operand that will be entered next.
     * Go to computation state.
     * Go to error if the number in the display does not parse properly into a floating point number.
     * Same as accumulating state.
     * @param calc The calculator model (context)
     * @param op 
     */
    public void enterOp(InfixCalc calc, IBinOp op) {
        try {
            //            System.out.println("Start State: enter op " + op);
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setPendingOp(op);
            calc.setCurState(CompState.Singleton);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        };
    }
    
    /**
     * Performs the pending operation, which may be a no-op, displays the result 
     * and updates the pending op to no-op.
     * @param calc The calculator model (context)
     */
    public void enterEqual(InfixCalc calc) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setNoOp();
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        };
    }
    
    /**
     * Enters a "0." into the display string. 
     * Go to point state.
     * @param calc The calculator model (context)
     */
    public void enterPoint(InfixCalc calc) {
        calc.setDisplay("0.");
        calc.setCurState(PointState.Singleton);
    }
}