package infixView;

import javax.swing.*;  // to use JFrame.
import java.awt.*;
import java.awt.event.*;
import infixModel.*;

/**
 * This is the GUI for the infix calculator model
 * For a graphical calculator use this as the main.
 * 
 */
public class InfixGUI extends AFrame{
    
    private InfixCalc _calc; // the "model"
    private JTextField _display;
    
    /**
     * Note how this inner class accesses the private _calc and _display fields.
     */
    private class DigitListener implements ActionListener {
        private char digit;
        DigitListener(char c) {
            digit = c;
        }
        
        public void actionPerformed(ActionEvent e) {
            _display.setText(_calc.enterDigit(digit));
        }
        
    }
    
    /**
     * Note how this inner class accesses the private _calc and _display fields.
     */
    private class OpListener implements ActionListener {
        private IBinOp op;
        OpListener(IBinOp o) {
            op = o;
        }
        
        public void actionPerformed(ActionEvent e) {
            _display.setText(_calc.enterOp(op));
        }
        
    }
    
    /**
     * Default constructor, uses title of "Cheap Calculator"
     */
    public InfixGUI() {
        super("Cheap Calculator");
    }
    
    public InfixGUI(java.awt.event.WindowAdapter windowCloser) {
        super("Cheap Calculator", windowCloser);
    }
    
    /**
     * Initializes the GUI
     */
    protected void initialize() {
        JButton zeroJButton = new JButton("0");
        JButton threeJButton = new JButton("3");
        JButton fourJButton = new JButton("4");
        JButton fiveJButton = new JButton("5");
        JButton sixJButton = new JButton("6");
        JButton sevenJButton = new JButton("7");
        JButton eightJButton = new JButton("8");
        JButton nineJButton = new JButton("9");
        JButton pointJButton = new JButton(".");
        JButton equalsJButton = new JButton("=");
        JButton plusJButton = new JButton("+");
        JButton mulJButton = new JButton("x");
        JButton clearJButton = new JButton("C");
        _calc  = new InfixCalc();
        _display = new JTextField("0", 12);
        
        Container cp = getContentPane();
        cp.setLayout(new FlowLayout());
        cp.add(_display);
        _display.setBackground(Color.white);
        _display.setEnabled(false);
        
        cp.add(zeroJButton);
        zeroJButton.addActionListener(new DigitListener('0'));
        cp.add(threeJButton);
        threeJButton.addActionListener(new DigitListener('3'));
        cp.add(fourJButton);
        fourJButton.addActionListener(new DigitListener('4'));
        cp.add(fiveJButton);
        fiveJButton.addActionListener(new DigitListener('5'));
        cp.add(sixJButton);
        sixJButton.addActionListener(new DigitListener('6'));
        cp.add(sevenJButton);
        sevenJButton.addActionListener(new DigitListener('7'));
        cp.add(eightJButton);
        eightJButton.addActionListener(new DigitListener('8'));
        cp.add(nineJButton);
        nineJButton.addActionListener(new DigitListener('9'));
        
        cp.add(pointJButton);
        pointJButton.addActionListener(new ActionListener (){
            public void actionPerformed(ActionEvent e) {
                _display.setText(_calc.enterPoint());
            }
            
        });
        
        cp.add(plusJButton);
        plusJButton.addActionListener(new OpListener(AddOp.Singleton));
        cp.add(mulJButton);
        mulJButton.addActionListener(new OpListener(MulOp.Singleton));
        
        cp.add(equalsJButton);
        equalsJButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                _display.setText(_calc.enterEqual());
            }
        });
        
        cp.add(clearJButton);
        clearJButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                _display.setText(_calc.clear());
            }
        });
        cp.setBackground(Color.BLUE);
        setSize(400,200);
        setVisible(true);    
        
    }
    
    
}