function [origsignal, shortsignal, fft_black] = recprep(bit, rate, length, verbose)
%  [origsignal shortsignal fftshort] = recprep(bit, rate, length, verbose)
%
%  INPUTS:
%  bit = number of bits that data will be recorded at--usually 16 bits
%  rate = sampling rate--usually 8 bits
%  length = length in seconds of sample to be recorded
%  verbose = 1 for descriptions about recording, 0 for not
%
%  OUTPUTS:
%  origsignal = original sound file recorded
%  shortsignal =  middle of the signal with only 8000 samples
%  fftshort = fft of shortened, blackman-windowed signal with 
%     the low frequencies obliterated
%
%
%  First, a tone will be played that should be imitated in the recording.
%  Then we will record a sound file using the record function.
%  This signal will go into our prepare.m which will get rid of DC and the first
%  100 Hz, will take only the middle 8000 samples, compute the fft, and spit
%  these out with plots and sound.
%

x = 0:pi/16:2000;
%sound(sin(x)/1000);

[origsignal] = record(bit, rate, length, verbose);

[shortsignal fft_black] = prepare(origsignal);


